<?php
// admin.php
require __DIR__ . '/config.php';
require __DIR__ . '/db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['admin_autorizado'])) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Painel Admin - Formação de Preço';

include __DIR__ . '/header.php';
?>

<div class="grid">
  <div class="card" style="max-width:720px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Painel Administrativo</div>
      <span class="badge">ADMIN</span>
    </div>

    <div class="field">
      <label>Configurações do APP</label>
      <div class="hint">
        Ajuste nome do APP, preço, limites do Trial e senha de administrador.
      </div>
      <a href="admin_settings.php" class="btn" style="margin-top:6px; text-decoration:none;">
        <span class="dot"></span> Abrir Configurações
      </a>
    </div>

    <hr class="divider">

    <div class="field">
      <label>Gateways de Pagamento</label>
      <div class="hint">
        Configure Mercado Pago, Pagar.me, Asaas ou cadastre outros gateways.
      </div>
      <a href="admin_gateways.php" class="btn" style="margin-top:6px; text-decoration:none;">
        <span class="dot"></span> Gerenciar Gateways
      </a>
    </div>

    <hr class="divider">

    <div class="field">
      <a href="index.php" class="btn" style="text-decoration:none;">
        <span class="dot"></span> Ir para o APP
      </a>
    </div>
	
	<!-- dentro do grid de cards do admin.php -->
	<div class="card">
	  <div class="card-header">
		<div class="card-title">Clientes & Vendas</div>
		<span class="badge">RELATÓRIO</span>
	  </div>
	  <div class="field">
		<p class="hint">
		  Veja os clientes que já compraram o APP, status dos pagamentos e valores.
		</p>
	  </div>
	  <div class="field">
		<a href="admin_clientes.php" class="btn" style="width:100%;justify-content:center;text-decoration:none;">
		  <span class="dot"></span> Ver clientes e compras
		</a>
	  </div>
	</div>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
