<?php
// admin_settings.php
require __DIR__ . '/config.php';
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['admin_autorizado'])) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Admin - Configurações do APP';

$mensagemSucesso = '';
$mensagemErro    = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $app_name  = trim($_POST['app_name'] ?? 'Formação de Preço de Venda');
        $app_price = trim($_POST['app_price'] ?? '29.90');

        $trial_sims = trim($_POST['trial_max_simulacoes'] ?? '3');
        $trial_dias = trim($_POST['trial_max_dias'] ?? '7');

        $admin_password = trim($_POST['admin_password'] ?? '');

        set_app_setting($pdo, 'app_name', $app_name);
        set_app_setting($pdo, 'app_price', $app_price);
        set_app_setting($pdo, 'trial_max_simulacoes', $trial_sims);
        set_app_setting($pdo, 'trial_max_dias', $trial_dias);

        if ($admin_password !== '') {
            $hash = password_hash($admin_password, PASSWORD_DEFAULT);
            set_app_setting($pdo, 'admin_password_hash', $hash);
            // opcional: limpar senha em texto antiga
            set_app_setting($pdo, 'admin_password', '');
        }

        $mensagemSucesso = 'Configurações salvas com sucesso.';

    } catch (Throwable $e) {
        $mensagemErro = 'Erro ao salvar configurações: ' . $e->getMessage();
    }
}

$settings = get_all_app_settings($pdo);

$app_name   = $settings['app_name'] ?? ($APP_NAME ?? 'Formação de Preço de Venda');
$app_price  = $settings['app_price'] ?? '29.90';
$trial_sims = $settings['trial_max_simulacoes'] ?? '3';
$trial_dias = $settings['trial_max_dias'] ?? '7';

include __DIR__ . '/header.php';
?>

<div class="grid">
  <div class="card" style="max-width:780px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Configurações do APP</div>
      <span class="badge">ADMIN</span>
    </div>

    <?php if ($mensagemSucesso): ?>
      <div class="metric metric-highlight" style="margin-bottom:10px;">
        <div class="metric-label">
          <span>Sucesso</span>
        </div>
        <div class="metric-value metric-small">
          <?php echo htmlspecialchars($mensagemSucesso); ?>
        </div>
      </div>
    <?php endif; ?>

    <?php if ($mensagemErro): ?>
      <div class="metric metric-danger" style="margin-bottom:10px;">
        <div class="metric-label">
          <span>Erro</span>
        </div>
        <div class="metric-value metric-small">
          <?php echo htmlspecialchars($mensagemErro); ?>
        </div>
      </div>
    <?php endif; ?>

    <form method="post" action="admin_settings.php" style="margin:0;padding:0;">

      <div class="field-row">
        <div class="field">
          <label>Nome do APP</label>
          <input type="text" name="app_name" value="<?php echo htmlspecialchars($app_name); ?>">
        </div>
        <div class="field">
          <label>Preço do APP (R$)</label>
          <input type="number" step="0.01" name="app_price" value="<?php echo htmlspecialchars($app_price); ?>">
        </div>
      </div>

      <hr class="divider">

      <div class="field-row">
        <div class="field">
          <label>Trial - Máx. simulações</label>
          <input type="number" name="trial_max_simulacoes" value="<?php echo htmlspecialchars($trial_sims); ?>">
        </div>
        <div class="field">
          <label>Trial - Máx. dias</label>
          <input type="number" name="trial_max_dias" value="<?php echo htmlspecialchars($trial_dias); ?>">
        </div>
      </div>

      <div class="field">
        <label>Senha do Admin (deixe em branco para não alterar)</label>
        <input type="password" name="admin_password" value="">
        <div class="hint">
          Ao preencher, a senha será armazenada de forma segura (hash) e usada no login do admin.
        </div>
      </div>

      <hr class="divider">

      <div class="field-row">
        <div class="field">
          <button type="submit" class="btn" style="justify-content:center;width:100%;">
            <span class="dot"></span> Salvar configurações
          </button>
        </div>
        <div class="field">
          <!-- Botão para voltar ao menu inicial do Admin -->
          <a href="admin.php" class="btn" style="justify-content:center;width:100%;text-decoration:none;">
            <span class="dot"></span> Voltar ao painel Admin
          </a>
        </div>
      </div>

      <div class="hint">
        Use o botão "Voltar ao painel Admin" para retornar ao menu inicial do painel.
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
