<?php
// footer.php
?>
  </div><!-- .app -->

  <script>
    const plataformas = <?php
      echo json_encode($PLATAFORMAS, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    ?>;
    window.TRIAL_MODE = <?php echo !empty($_SESSION['usuario_trial']) ? 'true' : 'false'; ?>;
    window.TRIAL_MAX = <?php
      echo isset($TRIAL_MAX_SIMULACOES) ? (int)$TRIAL_MAX_SIMULACOES : 3;
    ?>;
    window.TRIAL_MAX_DIAS = <?php
      echo isset($TRIAL_MAX_DIAS) ? (int)$TRIAL_MAX_DIAS : 7;
    ?>;
    window.USER_NAME = <?php echo json_encode($_SESSION['usuario_nome'] ?? ''); ?>;
    window.USER_EMAIL = <?php echo json_encode($_SESSION['usuario_email'] ?? ''); ?>;

    let plataformaEmEdicao = null;

    function setPlataforma(key) {
      const p = plataformas[key];
      if (!p) return;
      const nomeEl = document.getElementById("plataforma_nome");
      if (nomeEl) nomeEl.textContent = p.nome;

      const elTaxaPlat = document.getElementById("comissao_plataforma");
      if (elTaxaPlat) elTaxaPlat.value = p.taxaPercent;

      const elCustoFixo = document.getElementById("custos_fixos_plataforma");
      if (elCustoFixo) {
        elCustoFixo.value = p.custoFixo.toFixed(2);
        formatMoneyInput("custos_fixos_plataforma");
      }

    }

    function onPlataformaChange() {
      const select = document.getElementById("select_plataforma");
      if (!select) return;
      const slug = select.value;
      if (slug) {
        setPlataforma(slug);
      } else {
        const nomeEl = document.getElementById("plataforma_nome");
        if (nomeEl) nomeEl.textContent = "—";
      }
    }

    function slugifyName(name) {
      return name
        .toLowerCase()
        .normalize("NFD").replace(/[\u0300-\u036f]/g, "")
        .replace(/[^a-z0-9]+/g, "_")
        .replace(/^_+|_+$/g, "");
    }

    function iniciarEdicaoPlataforma() {
      const select = document.getElementById("select_plataforma");
      if (!select) return;
      const slug = select.value;
      if (!slug) {
        alert("Selecione uma plataforma para editar.");
        return;
      }
      const p = plataformas[slug];
      if (!p) {
        alert("Plataforma não encontrada.");
        return;
      }

      plataformaEmEdicao = slug;

      const nomeEl = document.getElementById("nova_plataforma_nome");
      const taxaEl = document.getElementById("nova_plataforma_taxa");
      const custoEl = document.getElementById("nova_plataforma_custo_fixo");

      if (nomeEl) nomeEl.value = p.nome;
      if (taxaEl) taxaEl.value = p.taxaPercent;

      if (custoEl) {
        custoEl.value = p.custoFixo.toString().replace(".", ",");
        formatMoneyInput("nova_plataforma_custo_fixo");
      }

      const btnSalvar = document.getElementById("btn_salvar_plataforma");
      if (btnSalvar) btnSalvar.textContent = "Salvar edição";
    }

    function excluirPlataformaAtual() {
      const select = document.getElementById("select_plataforma");
      if (!select) return;
      const slug = select.value;
      if (!slug) {
        alert("Selecione uma plataforma para excluir.");
        return;
      }
      const p = plataformas[slug];
      if (!p) {
        alert("Plataforma não encontrada.");
        return;
      }

      if (!confirm('Deseja realmente excluir a plataforma "' + p.nome + '"?')) {
        return;
      }

      delete plataformas[slug];

      select.remove(select.selectedIndex);
      select.value = "";
      const nomeEl = document.getElementById("plataforma_nome");
      if (nomeEl) nomeEl.textContent = "—";

      plataformaEmEdicao = null;
      const btnSalvar = document.getElementById("btn_salvar_plataforma");
      if (btnSalvar) btnSalvar.textContent = "Adicionar plataforma";

    }

    function addNovaPlataforma() {
      const nome = getRawValue("nova_plataforma_nome").trim();
      const taxaRaw = getRawValue("nova_plataforma_taxa").replace(",", ".");
      const taxa = parseFloat(taxaRaw);
      const custo = parseNumber("nova_plataforma_custo_fixo");

      if (!nome) {
        alert("Informe o nome da plataforma.");
        return;
      }
      if (isNaN(taxa)) {
        alert("Informe a taxa em % (ex: 10).");
        return;
      }

      let slug;
      if (plataformaEmEdicao) {
        slug = plataformaEmEdicao;
      } else {
        slug = slugifyName(nome);
        if (!slug) {
          alert("Nome de plataforma inválido.");
          return;
        }
      }

      let custoFixo = isNaN(custo) ? 0 : custo;

      if (!plataformaEmEdicao && plataformas[slug]) {
        const sobrescrever = confirm("Já existe uma plataforma com esse identificador. Deseja sobrescrever?");
        if (!sobrescrever) return;
      }

      plataformas[slug] = {
        nome: nome,
        taxaPercent: taxa,
        custoFixo: custoFixo
      };

      const select = document.getElementById("select_plataforma");
      if (select) {
        let opt = select.querySelector('option[value="' + slug + '"]');
        if (!opt) {
          opt = document.createElement("option");
          opt.value = slug;
          select.appendChild(opt);
        }
        opt.textContent = nome;
        select.value = slug;
      }

      const nomeEl = document.getElementById("plataforma_nome");
      if (nomeEl) nomeEl.textContent = nome;

      const nomeEl2 = document.getElementById("nova_plataforma_nome");
      const taxaEl2 = document.getElementById("nova_plataforma_taxa");
      const custoEl2 = document.getElementById("nova_plataforma_custo_fixo");
      if (nomeEl2) nomeEl2.value = "";
      if (taxaEl2) taxaEl2.value = "";
      if (custoEl2) custoEl2.value = "";

      plataformaEmEdicao = null;
      const btnSalvar = document.getElementById("btn_salvar_plataforma");
      if (btnSalvar) btnSalvar.textContent = "Adicionar plataforma";

      setPlataforma(slug);
    }

    function setModoResultado(mode) {
      const direto = document.getElementById("modo_direto");
      const reverso = document.getElementById("modo_reverso");
      const btnDireto = document.getElementById("btn_modo_direto");
      const btnReverso = document.getElementById("btn_modo_reverso");

      if (mode === "reverso") {
        if (direto) direto.style.display = "none";
        if (reverso) reverso.style.display = "block";
        if (btnDireto) btnDireto.classList.remove("active");
        if (btnReverso) btnReverso.classList.add("active");
      } else {
        if (direto) direto.style.display = "block";
        if (reverso) reverso.style.display = "none";
        if (btnDireto) btnDireto.classList.add("active");
        if (btnReverso) btnReverso.classList.remove("active");
      }
    }

    function getRawValue(id) {
      const el = document.getElementById(id);
      if (!el) return "";
      return String(el.value ?? "");
    }

    function parseNumber(id) {
      const el = document.getElementById(id);
      if (!el) return 0;
      let v = String(el.value ?? "");
      v = v.replace(/R\$/gi, "").replace(/\s/g, "");
      const hasComma = v.indexOf(",") !== -1;

      if (hasComma) {
        v = v.replace(/\./g, "").replace(",", ".");
      }
      const num = parseFloat(v);
      return isNaN(num) ? 0 : num;
    }

    function formatMoneyInput(id) {
      const el = document.getElementById(id);
      if (!el) return;
      const raw = getRawValue(id);
      const num = parseNumber(id);

      if (raw.trim() === "" || isNaN(num)) {
        el.value = "";
        return;
      }

      el.value =
        "R$ " +
        num.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2
        });
    }

    function unformatMoneyInput(id) {
      const el = document.getElementById(id);
      if (!el) return;
      const num = parseNumber(id);
      if (isNaN(num)) {
        el.value = "";
        return;
      }
      el.value = num.toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2,
        useGrouping: false
      });
    }

    function attachCurrencyMask(id) {
      const el = document.getElementById(id);
      if (!el) return;
      el.addEventListener("focus", () => {
        unformatMoneyInput(id);
        setTimeout(() => { try { el.select(); } catch (e) {} }, 0);
      });
      el.addEventListener("blur", () => {
        formatMoneyInput(id);
      });
      formatMoneyInput(id);
    }

    function parsePercent(id) {
      let v = parseNumber(id);
      if (v > 1) v = v / 100;
      return v;
    }

    function formatMoney(v) {
      return v.toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
        minimumFractionDigits: 2
      });
    }

    function formatPercent(v) {
      return (v * 100).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
      }) + "%";
    }

    function calcularSimplesComercio(rbt12) {
      let aliquotaNominal = 0;
      let deducao = 0;

      if (rbt12 > 0 && rbt12 <= 180000) {
        aliquotaNominal = 0.04; deducao = 0;
      } else if (rbt12 <= 360000) {
        aliquotaNominal = 0.073; deducao = 5940;
      } else if (rbt12 <= 720000) {
        aliquotaNominal = 0.095; deducao = 13860;
      } else if (rbt12 <= 1800000) {
        aliquotaNominal = 0.107; deducao = 22500;
      } else if (rbt12 <= 3600000) {
        aliquotaNominal = 0.143; deducao = 87300;
      } else if (rbt12 <= 4800000) {
        aliquotaNominal = 0.19; deducao = 378000;
      } else {
        aliquotaNominal = 0;
        deducao = 0;
      }

      const impostoDevido = rbt12 > 0 ? (rbt12 * aliquotaNominal - deducao) : 0;
      const aliquotaEfetiva = rbt12 > 0 ? (impostoDevido / rbt12) : 0;

      return {
        aliquotaNominal,
        deducao,
        aliquotaEfetiva,
        impostoDevido
      };
    }

    function atualizarRegimeUI() {
      const regimeEl = document.getElementById("regime_tributario");
      const regime = regimeEl ? regimeEl.value : "simples";

      const grupoSimples = document.getElementById("grupo_simples_maturidade");
      const grupoMeses = document.getElementById("grupo_meses_atividade");

      if (!grupoSimples || !grupoMeses) return;

      if (regime === "simples") {
        grupoSimples.style.display = "block";
        const matEl = document.getElementById("simples_maturidade");
        const tipo = matEl ? matEl.value : "mais_12";
        if (tipo === "menos_12") {
          grupoMeses.style.display = "block";
        } else {
          grupoMeses.style.display = "none";
        }
      } else {
        grupoSimples.style.display = "none";
        grupoMeses.style.display = "none";
      }
    }

    function calcularDadosImposto() {
      const regimeEl = document.getElementById("regime_tributario");
      const regime = regimeEl ? regimeEl.value : "simples";

      const fatBase = parseNumber("fat_12m");

      const dados = {
        regime,
        impostoPercent: 0,
        aliquotaNominal: 0,
        deducao: 0,
        impostoEstimado: 0
      };

      if (regime === "simples") {
        let rbt12 = fatBase;
        const matEl = document.getElementById("simples_maturidade");
        const tipo = matEl ? matEl.value : "mais_12";

        if (tipo === "menos_12") {
          const meses = parseNumber("meses_atividade");
          if (meses > 0) {
            rbt12 = (fatBase / meses) * 12;
          }
        }

        const res = calcularSimplesComercio(rbt12);
        dados.impostoPercent = res.aliquotaEfetiva;
        dados.aliquotaNominal = res.aliquotaNominal;
        dados.deducao = res.deducao;
        dados.impostoEstimado = res.impostoDevido;

      } else if (regime === "lucro_presumido") {
        dados.impostoPercent = 0.0593;
      } else if (regime === "lucro_real") {
        dados.impostoPercent = 0.12;
      }

      return dados;
    }

    function calcular() {
      const cmv = parseNumber("cmv");
      const custosOperacionais = parseNumber("custos_operacionais");
      const custosFixosPlataforma = parseNumber("custos_fixos_plataforma");

      const comissaoGestao = parsePercent("comissao_gestao");
      const comissaoPlataforma = parsePercent("comissao_plataforma");
      const lucroDesejado = parsePercent("lucro_desejado");

      const dadosImp = calcularDadosImposto();
      const impostosPercent = dadosImp.impostoPercent;

      const precoCusto = cmv + custosOperacionais + custosFixosPlataforma;

      const ctv = comissaoGestao + comissaoPlataforma + impostosPercent + lucroDesejado;
      const markup = 1 - ctv;

      let precoVenda = 0;
      let lucro = 0;

      if (markup > 0) {
        precoVenda = precoCusto / markup;
        lucro = precoVenda * lucroDesejado;
        const alertEl = document.getElementById("metric_alert");
        if (alertEl) alertEl.style.display = "none";
      } else {
        precoVenda = 0;
        lucro = 0;
        const alertEl = document.getElementById("metric_alert");
        if (alertEl) alertEl.style.display = "block";
      }

      const pcEl = document.getElementById("out_preco_custo");
      if (pcEl) pcEl.textContent = formatMoney(precoCusto);

      const pvEl = document.getElementById("out_preco_venda");
      if (pvEl) pvEl.textContent = formatMoney(precoVenda);

      const lucroEl = document.getElementById("out_lucro");
      if (lucroEl) lucroEl.textContent = formatMoney(lucro);

      const elCtv = document.getElementById("out_ctv");
      if (elCtv) elCtv.textContent = formatPercent(ctv);

      const elMarkup = document.getElementById("out_markup");
      if (elMarkup) elMarkup.textContent = formatPercent(markup);

      const elImpReal = document.getElementById("out_imposto_real");
      if (elImpReal) elImpReal.textContent = formatPercent(impostosPercent);

      const elAliquota = document.getElementById("out_aliquota");
      const elDeducao = document.getElementById("out_deducao");
      const elImpEst = document.getElementById("out_imposto_estimado");

      const dadosImp2 = calcularDadosImposto();
      if (dadosImp2.regime === "simples") {
        if (elAliquota) elAliquota.textContent = formatPercent(dadosImp2.aliquotaNominal);
        if (elDeducao) elDeducao.textContent = formatMoney(dadosImp2.deducao);
        if (elImpEst) elImpEst.textContent = formatMoney(dadosImp2.impostoEstimado);
      } else {
        if (elAliquota) elAliquota.textContent = formatPercent(0);
        if (elDeducao) elDeducao.textContent = formatMoney(0);
        if (elImpEst) elImpEst.textContent = formatMoney(0);
      }

      const outCustoRev = document.getElementById("out_preco_custo_rev");
      if (outCustoRev) outCustoRev.textContent = formatMoney(precoCusto);
    }

    function calcularReverso() {
      const cmv = parseNumber("cmv");
      const custosOperacionais = parseNumber("custos_operacionais");
      const custosFixosPlataforma = parseNumber("custos_fixos_plataforma");

      const comissaoGestao = parsePercent("comissao_gestao");
      const comissaoPlataforma = parsePercent("comissao_plataforma");
      const dadosImp = calcularDadosImposto();
      const impostosPercent = dadosImp.impostoPercent;

      const precoVendaDesejado = parseNumber("pv_reverso");

      const precoCusto =
        cmv +
        custosOperacionais +
        custosFixosPlataforma;

      if (!precoVendaDesejado || precoVendaDesejado <= 0) {
        if (document.getElementById("out_preco_custo_rev")) {
          document.getElementById("out_preco_custo_rev").textContent = formatMoney(precoCusto);
        }
        if (document.getElementById("out_taxas_totais_rev")) {
          document.getElementById("out_taxas_totais_rev").textContent = formatMoney(0);
        }
        if (document.getElementById("out_lucro_rev")) {
          document.getElementById("out_lucro_rev").textContent = formatMoney(0);
        }
        if (document.getElementById("out_lucro_percent_rev")) {
          document.getElementById("out_lucro_percent_rev").textContent = formatPercent(0);
        }
        return;
      }

      const T = comissaoGestao + comissaoPlataforma + impostosPercent;

      const taxasTotais = precoVendaDesejado * T;
      const lucro = precoVendaDesejado - precoCusto - taxasTotais;
      const lucroPercent = precoVendaDesejado > 0 ? (lucro / precoVendaDesejado) : 0;

      if (document.getElementById("out_preco_custo_rev")) {
        document.getElementById("out_preco_custo_rev").textContent = formatMoney(precoCusto);
      }
      if (document.getElementById("out_taxas_totais_rev")) {
        document.getElementById("out_taxas_totais_rev").textContent = formatMoney(taxasTotais);
      }
      if (document.getElementById("out_lucro_rev")) {
        document.getElementById("out_lucro_rev").textContent = formatMoney(lucro);
      }
      if (document.getElementById("out_lucro_percent_rev")) {
        document.getElementById("out_lucro_percent_rev").textContent = formatPercent(lucroPercent);
      }
    }

    function atualizarBadgeTrial(restantes, diasRestantes) {
      const badge = document.getElementById("trial_badge");
      if (!badge) return;
      if (restantes <= 0 || diasRestantes <= 0) {
        badge.textContent = "Trial encerrado";
      } else {
        let txt = "Trial: " + restantes + " simulações restantes";
        if (diasRestantes != null) {
          txt += " · " + diasRestantes + " dia(s)";
        }
        badge.textContent = txt;
      }
    }

    function chamarRecalculoReal() {
      calcular();
      calcularReverso();
    }

    function redirecionarParaPagamento() {
      const params = new URLSearchParams();
      if (window.USER_NAME) params.append("nome", window.USER_NAME);
      if (window.USER_EMAIL) params.append("email", window.USER_EMAIL);
      window.location.href = "pagamento.php?" + params.toString();
    }

    function recalcularTudo() {
  // Se não existe o campo de custo do produto (cmv),
  // significa que estamos em outra página (login, pagamento, trial, etc).
  // Nessas páginas NÃO devemos contar simulação nem redirecionar.
  const cmvEl = document.getElementById("cmv");
  if (!cmvEl) {
    return; // simplesmente não faz nada
  }

  // Se não está em modo Trial, recalcula normalmente
  if (!window.TRIAL_MODE) {
    chamarRecalculoReal();
    return;
  }

  // Em modo Trial: conta simulação no servidor
  fetch("conta_simulacao.php", {
    method: "POST",
    headers: { "X-Requested-With": "XMLHttpRequest" }
  })
    .then((r) => r.json())
    .then((data) => {
      if (!data.ok) {
        let msgBase = "Seu período de teste gratuito terminou.";
        if (data.motivo === "limite_alcancado") {
          msgBase = "Seu período de teste gratuito terminou. Você já utilizou todas as " + window.TRIAL_MAX + " simulações.";
        } else if (data.motivo === "expirado_dias") {
          msgBase = "Seu período de teste gratuito expirou. O limite de " + window.TRIAL_MAX_DIAS + " dias foi atingido.";
        }
        alert(msgBase + "\nVocê será redirecionado para a tela de pagamento para adquirir a licença completa.");
        atualizarBadgeTrial(0, 0);
        redirecionarParaPagamento();
        return;
      }
      if (typeof data.restantes !== "undefined") {
        atualizarBadgeTrial(data.restantes, data.dias_restantes ?? null);
      }
      chamarRecalculoReal();
    })
    .catch((err) => {
      console.error("Erro ao registrar simulação do trial:", err);
      chamarRecalculoReal();
    });
}

    window.addEventListener("DOMContentLoaded", () => {
      [
        "cmv",
        "custos_operacionais",
        "custos_fixos_plataforma",
        "fat_12m",
        "pv_reverso",
        "nova_plataforma_custo_fixo"
      ].forEach(attachCurrencyMask);

      document.querySelectorAll('input[type="text"], input[type="number"]').forEach((el) => {
        el.addEventListener("focus", function () {
          try { this.select(); } catch (e) {}
        });
      });

      const regimeEl = document.getElementById("regime_tributario");
      if (regimeEl) {
        regimeEl.addEventListener("change", () => {
          atualizarRegimeUI();
        });
      }
      const simplesMatEl = document.getElementById("simples_maturidade");
      if (simplesMatEl) {
        simplesMatEl.addEventListener("change", () => {
          atualizarRegimeUI();
        });
      }

      atualizarRegimeUI();
    });

    document.addEventListener("keydown", function (e) {
      if (e.key !== "Enter") return;

      const target = e.target;
      if (!target) return;

      const tag = target.tagName;
      if (tag !== "INPUT" && tag !== "SELECT") return;

      e.preventDefault();

      const id = target.id || "";

      const moneyIds = [
        "cmv",
        "custos_operacionais",
        "custos_fixos_plataforma",
        "fat_12m",
        "pv_reverso",
        "nova_plataforma_custo_fixo"
      ];
      if (moneyIds.includes(id)) {
        formatMoneyInput(id);
      }
    });
  </script>
</body>
</html>
