<?php
// header.php
if (!isset($pageTitle)) {
    $pageTitle = 'Formação de Preço de Venda';
}
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        :root {
            --bg: #020617;
            --bg-card: #020617;
            --border-subtle: #1f2937;
            --accent: #22c55e;
            --accent-soft: #22c55e22;
            --accent-strong: #16a34a;
            --danger: #f97373;
            --text: #e5e7eb;
            --muted: #9ca3af;
            --shadow-soft: 0 18px 45px rgba(15, 23, 42, 0.7);
            --radius-xl: 18px;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top left, #1d283a 0, #020617 55%);
            color: var(--text);
            min-height: 100vh;
        }
        .app {
            max-width: 1200px;
            margin: 0 auto;
            padding: 16px 14px 24px;
        }
        @media (max-width: 640px) {
            .app {
                padding: 12px 10px 20px;
            }
        }

        /* TOPO / CABEÇALHO */
        .topbar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
            margin-bottom: 18px;
            flex-wrap: wrap;
        }
        .topbar-title {
            font-size: 1rem;
            font-weight: 600;
            letter-spacing: 0.04em;
            text-transform: uppercase;
            color: var(--muted);
        }
        .topbar-title span { color: var(--accent); }

        .topbar-user {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.8rem;
            color: var(--muted);
            flex-wrap: wrap;
        }
        .topbar-user a {
            color: var(--accent);
            text-decoration: none;
            font-weight: 500;
        }
        .topbar-user a:hover { text-decoration: underline; }

        /* Ajustes específicos para MOBILE */
        @media (max-width: 640px) {
            .topbar {
                flex-direction: column;
                align-items: center;
                justify-content: center;
                text-align: center;
                gap: 6px;
            }
            .topbar-title {
                text-align: center;
                width: 100%;
            }
            .topbar-user {
                width: 100%;
                justify-content: center;
                text-align: center;
            }
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 16px;
            align-items: flex-start;
        }

        .card {
            background: radial-gradient(circle at top, #111827ee 0, #020617ff 60%);
            border-radius: var(--radius-xl);
            padding: 16px 16px 18px;
            border: 1px solid #111827;
            box-shadow: var(--shadow-soft);
            backdrop-filter: blur(12px);
        }
        @media (max-width: 640px) {
            .card {
                padding: 14px 14px 16px;
                border-radius: 14px;
            }
        }

        .card-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 12px;
            gap: 8px;
            flex-wrap: wrap;
        }
        .card-title {
            font-size: 0.92rem;
            letter-spacing: 0.06em;
            text-transform: uppercase;
            color: var(--muted);
        }
        .badge {
            font-size: 0.7rem;
            padding: 3px 8px;
            border-radius: 999px;
            border: 1px solid var(--accent-soft);
            background: #022c22aa;
            color: var(--accent);
            text-transform: uppercase;
            letter-spacing: 0.08em;
            white-space: nowrap;
        }

        .field { margin-bottom: 10px; }
        .field-row {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 10px;
        }
        @media (max-width: 640px) {
            .field-row { grid-template-columns: 1fr; }
        }

        .field label {
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-size: 0.78rem;
            color: var(--muted);
            margin-bottom: 4px;
            gap: 6px;
        }
        .field input,
        .field select {
            width: 100%;
            padding: 7px 9px;
            border-radius: 10px;
            border: 1px solid var(--border-subtle);
            background: #020617;
            color: var(--text);
            font-size: 0.8rem;
            outline: none;
        }
        .field input::placeholder { color: #4b5563; }
        .field select { cursor: pointer; }
        .field select:focus,
        .field input:focus {
            border-color: var(--accent-strong);
            box-shadow: 0 0 0 1px var(--accent-soft);
        }

        /* Combo de plataformas: fundo claro + texto preto */
        select#select_plataforma {
            color: #000;
            background: #e5e7eb;
        }
        select#select_plataforma:focus { color: #000; }

        .hint {
            font-size: 0.72rem;
            color: var(--muted);
            margin-top: 3px;
        }

        .code {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            font-size: 0.65rem;
            color: #6ee7b7;
            padding: 1px 6px;
            border-radius: 999px;
            border: 1px solid rgba(148, 163, 184, 0.4);
            background: rgba(15, 23, 42, 0.9);
            margin-left: 6px;
            white-space: nowrap;
        }

        .divider {
            border: none;
            border-top: 1px dashed rgba(75, 85, 99, 0.6);
            margin: 12px 0;
        }

        .result-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 10px;
        }

        .metric {
            border-radius: 14px;
            border: 1px solid rgba(75, 85, 99, 0.9);
            padding: 8px 10px;
            background: radial-gradient(circle at top left, #020617 0, #020617 60%);
        }
        .metric-label {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 0.75rem;
            color: var(--muted);
            margin-bottom: 2px;
        }
        .metric-value {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            font-size: 0.98rem;
            font-weight: 600;
            word-break: break-word;
        }
        .metric-small { font-size: 0.85rem; }
        .metric-highlight {
            border-color: var(--accent-soft);
            background: radial-gradient(circle at top, #064e3b 0, #020617 65%);
        }
        .metric-danger {
            border-color: rgba(248, 113, 113, 0.5);
            background: radial-gradient(circle at top, #7f1d1d 0, #020617 65%);
        }
        .hidden-metric { display: none; }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 7px 10px;
            border-radius: 999px;
            border: 1px solid rgba(34, 197, 94, 0.4);
            background: radial-gradient(circle at top, #16a34a 0, #15803d 40%, #064e3b 100%);
            color: white;
            font-size: 0.78rem;
            font-weight: 500;
            cursor: pointer;
            text-decoration: none;
            transition: transform 0.08s ease-out, box-shadow 0.08s ease-out, border-color 0.1s;
            box-shadow: 0 12px 25px rgba(22, 163, 74, 0.45);
        }
        .btn .dot {
            width: 7px;
            height: 7px;
            border-radius: 999px;
            background: #bbf7d0;
        }
        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 16px 30px rgba(22, 163, 74, 0.7);
        }
        .btn:active {
            transform: translateY(1px);
            box-shadow: 0 6px 12px rgba(22, 163, 74, 0.6);
        }

        .pill {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 2px 8px;
            border-radius: 999px;
            border: 1px solid rgba(148, 163, 184, 0.5);
            background: rgba(15, 23, 42, 0.9);
            font-size: 0.7rem;
            color: var(--muted);
        }
        .pill .dot {
            width: 6px;
            height: 6px;
            border-radius: 999px;
            background: var(--accent);
        }

        .mode-tabs {
            display: inline-flex;
            border-radius: 999px;
            padding: 2px;
            background: rgba(15, 23, 42, 0.95);
            border: 1px solid rgba(55, 65, 81, 0.9);
            margin-bottom: 8px;
        }
        .mode-tab-btn {
            border: none;
            background: transparent;
            color: var(--muted);
            font-size: 0.72rem;
            padding: 4px 10px;
            border-radius: 999px;
            cursor: pointer;
            white-space: nowrap;
        }
        .mode-tab-btn.active {
            background: radial-gradient(circle at top, #16a34a 0, #22c55e 70%);
            color: #0b1120;
            font-weight: 600;
        }

        .footer-note {
            font-size: 0.72rem;
            color: var(--muted);
            margin-top: 10px;
        }

        table.admin-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.78rem;
        }
        table.admin-table th,
        table.admin-table td {
            border: 1px solid rgba(55,65,81,0.8);
            padding: 6px 8px;
            text-align: left;
        }
        table.admin-table th {
            background: rgba(15,23,42,0.9);
        }

        @media (max-width: 480px) {
            .topbar-title { font-size: 0.9rem; }
            .card-title { font-size: 0.86rem; }
            .field input,
            .field select { font-size: 0.78rem; }
            .metric-value { font-size: 0.92rem; }
        }
    </style>
	
	<script>
	document.addEventListener('keydown', function(e) {
	  if (e.key !== 'Enter') return;

	  const target = e.target;
	  if (!target.matches('input, select, textarea')) return;

	  // evita enviar formulários ao pressionar Enter
	  e.preventDefault();

	  // lista de campos focáveis
	  const focusables = Array.from(document.querySelectorAll('input, select, textarea'))
		.filter(function(el) {
		  if (el.type === 'hidden' || el.disabled) return false;
		  // só campos visíveis
		  if (el.offsetParent === null) return false;
		  return true;
		});

	  const idx = focusables.indexOf(target);
	  if (idx > -1 && idx + 1 < focusables.length) {
		focusables[idx + 1].focus();
	  }
	});
	</script>

</head>
<body>
<div class="app">
  <div class="topbar">
    <div class="topbar-title">
      <span>APP</span> — Formação de Preço de Venda
    </div>
    <div class="topbar-user">
      <?php if (!empty($_SESSION['usuario_autorizado'])): ?>
        <span>Olá,
          <?php echo htmlspecialchars($_SESSION['usuario_nome'] ?? $_SESSION['usuario_email'] ?? 'Usuário'); ?>
        </span>
        <?php if (!empty($_SESSION['usuario_trial'])): ?>
          <span>&bull;</span>
          <span style="color:#fde68a;">Modo Trial</span>
        <?php endif; ?>
        <span>&bull;</span>
        <a href="index.php">App</a>
        <span>&bull;</span>
        <a href="logout.php">Sair</a>
      <?php else: ?>
        <a href="login.php">Login</a>
        <span>&bull;</span>
        <a href="cadastro.php">Comprar APP</a>
        <span>&bull;</span>
        <a href="trial.php">Testar grátis</a>
      <?php endif; ?>
      <span>&bull;</span>
      <a href="admin_login.php" style="opacity:0.7;">Admin</a>
    </div>
  </div>
