<?php
// pagamento.php - tela para o usuário realizar a compra

require __DIR__ . '/config.php';
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['usuario_email'])) {
    header('Location: login.php');
    exit;
}

$emailUsuario = $_SESSION['usuario_email'];
$nomeUsuario  = $_SESSION['usuario_nome'] ?? '';

// pega valor configurado do app
$appPriceStr = get_app_setting($pdo, 'app_price', '29.90');
$appPriceVal = (float)$appPriceStr;

// última venda do usuário (qualquer gateway)
$stmt = $pdo->prepare("
    SELECT *
    FROM vendas_app
    WHERE email = :email
    ORDER BY updated_at DESC
    LIMIT 1
");
$stmt->execute([':email' => $emailUsuario]);
$ultimaVenda = $stmt->fetch(PDO::FETCH_ASSOC);

$pageTitle = 'Pagamento do APP';

include __DIR__ . '/header.php';
?>

<div class="grid" style="max-width:800px;margin:0 auto;">
  <div class="card" style="grid-column:1 / -1;">
    <div class="card-header">
      <div class="card-title">Pagamento do APP</div>
      <span class="badge">LICENÇA</span>
    </div>

    <div class="field">
      <p class="hint">
        Valor da licença: <strong>R$ <?php echo number_format($appPriceVal, 2, ',', '.'); ?></strong>
      </p>
      <p class="hint">
        Usuário logado: <strong><?php echo htmlspecialchars($emailUsuario); ?></strong>
      </p>
    </div>

    <?php if ($ultimaVenda): ?>
      <div class="card" style="margin-bottom:10px;">
        <div class="card-header">
          <div class="card-title">Status atual do seu pagamento</div>
          <span class="badge"><?php echo htmlspecialchars($ultimaVenda['gateway_slug'] ?? ''); ?></span>
        </div>
        <div class="field">
          <p>
            Status:
            <?php
              $st = $ultimaVenda['status'] ?? '';
              if ($st === 'approved') {
                  echo '<span style="color:#16a34a;font-weight:600;">Aprovado</span>';
              } elseif ($st) {
                  echo htmlspecialchars($st);
              } else {
                  echo 'Indefinido';
              }
            ?>
          </p>
          <p>Valor: R$ <?php echo number_format((float)($ultimaVenda['amount'] ?? 0), 2, ',', '.'); ?></p>
          <p>Última atualização: <?php echo htmlspecialchars($ultimaVenda['updated_at'] ?? $ultimaVenda['created_at'] ?? ''); ?></p>
        </div>
      </div>

      <?php if (($ultimaVenda['status'] ?? '') === 'approved'): ?>
        <div class="metric metric-highlight" style="margin-bottom:10px;">
          <div class="metric-label">
            <span>Seu pagamento já foi aprovado 🎉</span>
          </div>
          <div class="metric-value metric-small">
            Você já pode usar o APP normalmente. Se algo não liberar, saia e entre novamente com seu login.
          </div>
        </div>
      <?php else: ?>
        <div class="metric" style="margin-bottom:10px;">
          <div class="metric-label">
            <span>Pagamento ainda não aprovado</span>
          </div>
          <div class="metric-value metric-small">
            Caso você já tenha concluído o pagamento na aba do gateway, aguarde alguns instantes
            para o sistema receber a confirmação (via webhook). Depois disso, faça login novamente.
          </div>
        </div>
      <?php endif; ?>

    <?php else: ?>
      <div class="metric" style="margin-bottom:10px;">
        <div class="metric-label">
          <span>Nenhum pagamento encontrado para este e-mail</span>
        </div>
        <div class="metric-value metric-small">
          Use o botão abaixo para realizar a compra do APP pela primeira vez.
        </div>
      </div>
    <?php endif; ?>

    <form method="post" action="criar_pagamento.php" target="_blank" class="form-cadastro">
      <div class="field-row">
        <div class="field">
          <label>Nome completo</label>
          <input type="text" name="nome" value="<?php echo htmlspecialchars($nomeUsuario); ?>" required>
        </div>
        <div class="field">
          <label>E-mail</label>
          <input type="email" name="email" value="<?php echo htmlspecialchars($emailUsuario); ?>" required>
        </div>
      </div>

      <div class="field-row">
        <div class="field">
          <label>WhatsApp (DDD + número)</label>
          <input type="text" name="whatsapp" placeholder="(31) 99999-9999" required>
        </div>
        <div class="field">
          <label>CPF</label>
          <input type="text" name="doc" placeholder="000.000.000-00" required>
        </div>
      </div>

      <input type="hidden" name="preco" value="<?php echo htmlspecialchars($appPriceVal); ?>">

      <div class="field">
        <button type="submit" class="btn" style="width:100%;justify-content:center;">
          Ir para o pagamento
        </button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
