<?php
// pendente.php

require __DIR__ . '/config.php';
$pageTitle = 'Pagamento em análise - Formação de Preço';
include __DIR__ . '/header.php';

$paymentId    = isset($_GET['payment_id']) ? $_GET['payment_id'] : null;
$status       = isset($_GET['status']) ? $_GET['status'] : null;
$preferenceId = isset($_GET['preference_id']) ? $_GET['preference_id'] : null;
?>

<div class="grid">
  <div class="card" style="max-width:680px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Pagamento em análise ⏳</div>
      <span class="badge">PENDENTE</span>
    </div>

    <div class="field">
      <label>Situação do pagamento</label>
      <div class="hint">
        O Mercado Pago ainda está processando seu pagamento.  
        Assim que o valor for confirmado, você poderá acessar o aplicativo normalmente.
      </div>
    </div>

    <?php if ($paymentId || $status || $preferenceId): ?>
      <hr class="divider">
      <div class="field">
        <label>Detalhes técnicos (para você)</label>
        <div class="hint">
          <?php if ($paymentId): ?>
            <div><strong>payment_id:</strong> <?php echo htmlspecialchars($paymentId); ?></div>
          <?php endif; ?>
          <?php if ($status): ?>
            <div><strong>status:</strong> <?php echo htmlspecialchars($status); ?></div>
          <?php endif; ?>
          <?php if ($preferenceId): ?>
            <div><strong>preference_id:</strong> <?php echo htmlspecialchars($preferenceId); ?></div>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>

    <hr class="divider">

    <div class="field">
      <a href="index.php" class="btn" style="text-decoration:none;display:inline-flex;justify-content:center;">
        <span class="dot"></span> Voltar para o app
      </a>
    </div>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
