<?php
// plataformas_api.php
require __DIR__ . '/config.php';
require __DIR__ . '/db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Se quiser, pode checar se o usuário é admin aqui
// if (empty($_SESSION['usuario_autorizado'])) { ... }

header('Content-Type: application/json; charset=utf-8');

$acao = $_POST['acao'] ?? '';

try {
    if ($acao === 'salvar') {
        $nome  = trim($_POST['nome'] ?? '');
        $slug  = trim($_POST['slug'] ?? '');
        $taxa  = str_replace(',', '.', $_POST['taxa_percent'] ?? '0');
        $custo = str_replace(',', '.', $_POST['custo_fixo'] ?? '0');

        $taxa  = (float)$taxa;
        $custo = (float)$custo;

        if ($nome === '' || $slug === '') {
            throw new Exception('Nome e slug são obrigatórios.');
        }

        // Verifica se já existe
        $stmt = $pdo->prepare("SELECT id FROM plataformas WHERE slug = :slug LIMIT 1");
        $stmt->execute(['slug' => $slug]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            // UPDATE
            $stmtUp = $pdo->prepare("
                UPDATE plataformas
                SET nome = :nome,
                    taxa_plataforma = :taxa,
                    custo_fixo = :custo,
                    ativo = 1
                WHERE slug = :slug
            ");
            $stmtUp->execute([
                'nome'  => $nome,
                'taxa'  => $taxa,
                'custo' => $custo,
                'slug'  => $slug,
            ]);
        } else {
            // INSERT
            $stmtIns = $pdo->prepare("
                INSERT INTO plataformas (nome, slug, taxa_plataforma, custo_fixo, ativo, ordem)
                VALUES (:nome, :slug, :taxa, :custo, 1, 0)
            ");
            $stmtIns->execute([
                'nome'  => $nome,
                'slug'  => $slug,
                'taxa'  => $taxa,
                'custo' => $custo,
            ]);
        }

        echo json_encode([
            'ok' => true,
            'plataforma' => [
                'slug'       => $slug,
                'nome'       => $nome,
                'taxaPercent'=> $taxa,
                'custoFixo'  => $custo,
            ],
        ]);
        exit;
    }

    if ($acao === 'excluir') {
        $slug = trim($_POST['slug'] ?? '');
        if ($slug === '') {
            throw new Exception('Slug inválido.');
        }

        // Soft delete (marca inativo)
        $stmtDel = $pdo->prepare("UPDATE plataformas SET ativo = 0 WHERE slug = :slug");
        $stmtDel->execute(['slug' => $slug]);

        echo json_encode(['ok' => true]);
        exit;
    }

    throw new Exception('Ação inválida.');

} catch (Exception $e) {
    echo json_encode([
        'ok'  => false,
        'msg' => $e->getMessage(),
    ]);
    exit;
}
