<?php
// admin_clients.php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['admin_autorizado'])) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Admin - Clientes e Vendas';

// Busca últimas vendas, agrupadas por e-mail (opcional: você pode tirar o GROUP se quiser ver todas)
$sql = "
    SELECT
        id,
        nome,
        email,
        whatsapp,
        tipo,
        doc,
        gateway_slug,
        payment_id,
        status,
        status_detail,
        amount,
        created_at,
        updated_at
    FROM vendas_app
    ORDER BY created_at DESC
    LIMIT 200
";
$stmt = $pdo->query($sql);
$vendas = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/header.php';
?>

<div class="grid">
  <div class="card" style="grid-column:1/-1;max-width:1100px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Clientes e Vendas</div>
      <span class="badge">ADMIN</span>
    </div>

    <div class="field-row" style="margin-bottom:10px;">
      <div class="field">
        <a href="admin.php" class="btn" style="text-decoration:none;justify-content:center;">
          <span class="dot"></span> Voltar ao painel Admin
        </a>
      </div>
    </div>

    <div class="field">
      <table class="admin-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Cliente</th>
            <th>E-mail</th>
            <th>WhatsApp</th>
            <th>Doc</th>
            <th>Gateway</th>
            <th>Pagamento</th>
            <th>Status</th>
            <th>Valor (R$)</th>
            <th>Criação</th>
            <th>Atualização</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($vendas): ?>
          <?php foreach ($vendas as $v): ?>
            <tr>
              <td><?php echo (int)$v['id']; ?></td>
              <td><?php echo htmlspecialchars($v['nome'] ?: '-'); ?></td>
              <td><?php echo htmlspecialchars($v['email'] ?: '-'); ?></td>
              <td><?php echo htmlspecialchars($v['whatsapp'] ?: '-'); ?></td>
              <td><?php echo htmlspecialchars($v['doc'] ?: '-'); ?></td>
              <td><?php echo htmlspecialchars($v['gateway_slug']); ?></td>
              <td><?php echo htmlspecialchars($v['payment_id']); ?></td>
              <td>
                <?php
                  $status = $v['status'] ?: '-';
                  if ($status === 'approved') {
                      echo '<span style="color:#16a34a;font-weight:600;">APROVADO</span>';
                  } elseif ($status === 'pending') {
                      echo '<span style="color:#f97316;font-weight:600;">PENDENTE</span>';
                  } else {
                      echo htmlspecialchars($status);
                  }
                ?>
              </td>
              <td><?php echo number_format((float)$v['amount'], 2, ',', '.'); ?></td>
              <td><?php echo htmlspecialchars($v['created_at']); ?></td>
              <td><?php echo htmlspecialchars($v['updated_at']); ?></td>
            </tr>
          <?php endforeach; ?>
        <?php else: ?>
          <tr><td colspan="11">Nenhuma venda registrada ainda.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
