<?php
// admin_login.php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$pageTitle = 'Login Admin - Formação de Preço de Venda';

$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $senha = isset($_POST['senha']) ? trim($_POST['senha']) : '';

    // Hash armazenado em app_settings.admin_password_hash (quando configurado pelo painel)
    $hash  = get_app_setting($pdo, 'admin_password_hash', null);
    // Fallback: senha em texto (seed inicial ou legado)
    $plain = get_app_setting($pdo, 'admin_password', $ADMIN_PASSWORD ?? '');

    $ok = false;

    if ($hash) {
        // Usa password_verify se tiver hash salvo
        if (password_verify($senha, $hash)) {
            $ok = true;
        }
    } else {
        // Se ainda não tem hash, compara com a senha em texto
        if ($senha !== '' && $senha === $plain) {
            $ok = true;
        }
    }

    if ($ok) {
        $_SESSION['admin_autorizado'] = true;
        header('Location: admin.php');
        exit;
    } else {
        $erro = 'Senha de administrador inválida.';
    }
}

include __DIR__ . '/header.php';
?>

<div class="grid">
  <div class="card" style="max-width:520px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Login do Administrador</div>
      <span class="badge">ADMIN</span>
    </div>

    <form method="post" action="admin_login.php" style="margin:0;padding:0;">

      <div class="field">
        <label>Senha do Admin</label>
        <input
          type="password"
          name="senha"
          id="senha"
          placeholder="Digite a senha do admin"
        >
        <div class="hint">
          A senha é definida em Admin &rarr; Configurações do APP.
        </div>
      </div>

      <?php if (!empty($erro)): ?>
        <div class="metric metric-danger" style="margin-top:8px;">
          <div class="metric-label">
            <span>Não foi possível entrar</span>
          </div>
          <div class="metric-value metric-small" style="font-size:0.8rem;">
            <?php echo htmlspecialchars($erro); ?>
          </div>
        </div>
      <?php endif; ?>

      <hr class="divider">

      <div class="field">
        <button
          type="submit"
          class="btn"
          style="width:100%;justify-content:center;font-size:0.9rem;"
        >
          <span class="dot"></span> Entrar no painel Admin
        </button>
      </div>
    </form>

    <div class="field" style="margin-top:10px;">
      <div class="hint">
        Voltar para o APP:<br>
        <a href="index.php" style="color:#38bdf8;text-decoration:none;">
          Ir para o APP de Formação de Preço
        </a>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
