<?php
// conta_simulacao.php
// Endpoint chamado via AJAX para contar simulações do modo trial
require __DIR__ . '/db.php';

// Carrega limites de trial a partir do banco (tabela app_settings)
require_once __DIR__ . '/functions.php';
$TRIAL_MAX_SIMULACOES = (int) get_app_setting($pdo, 'trial_max_simulacoes', '3');
$TRIAL_MAX_DIAS       = (int) get_app_setting($pdo, 'trial_max_dias', '7');
if ($TRIAL_MAX_SIMULACOES <= 0) {
  $TRIAL_MAX_SIMULACOES = 3;
}
if ($TRIAL_MAX_DIAS <= 0) {
  $TRIAL_MAX_DIAS = 7;
}



if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

header('Content-Type: application/json; charset=utf-8');

if (empty($_SESSION['usuario_trial']) || empty($_SESSION['usuario_email'])) {
  echo json_encode([
    'ok' => true,
    'restantes' => null,
    'dias_restantes' => null,
  ]);
  exit;
}

$email = $_SESSION['usuario_email'];

try {
  $stmt = $pdo->prepare('SELECT *, TIMESTAMPDIFF(DAY, created_at, NOW()) AS dias_desde FROM usuarios_trial WHERE email = :email LIMIT 1');
  $stmt->execute([':email' => $email]);
  $row = $stmt->fetch();

  if (!$row) {
    echo json_encode([
      'ok' => false,
      'motivo' => 'nao_encontrado',
      'restantes' => 0,
      'dias_restantes' => 0,
    ]);
    exit;
  }

  $simCount   = (int)$row['sim_count'];
  $diasDesde  = isset($row['dias_desde']) ? (int)$row['dias_desde'] : 0;

  if ($diasDesde >= (int)$TRIAL_MAX_DIAS) {
    $_SESSION['trial_restantes'] = 0;
    echo json_encode([
      'ok' => false,
      'motivo' => 'expirado_dias',
      'restantes' => 0,
      'dias_restantes' => 0,
    ]);
    exit;
  }

  if ($simCount >= (int)$TRIAL_MAX_SIMULACOES) {
    $_SESSION['trial_restantes'] = 0;
    echo json_encode([
      'ok' => false,
      'motivo' => 'limite_alcancado',
      'restantes' => 0,
      'dias_restantes' => max(0, (int)$TRIAL_MAX_DIAS - $diasDesde),
    ]);
    exit;
  }

  $simCount++;
  $stmtUp = $pdo->prepare('UPDATE usuarios_trial SET sim_count = :c WHERE email = :email');
  $stmtUp->execute([':c' => $simCount, ':email' => $email]);

  $restantes = max(0, (int)$TRIAL_MAX_SIMULACOES - $simCount);
  $diasRestantes = max(0, (int)$TRIAL_MAX_DIAS - $diasDesde);

  $_SESSION['trial_restantes'] = $restantes;

  echo json_encode([
    'ok'            => true,
    'restantes'     => $restantes,
    'dias_restantes'=> $diasRestantes,
  ]);
  exit;

} catch (Exception $e) {
  echo json_encode([
    'ok' => false,
    'motivo' => 'erro',
    'mensagem' => $e->getMessage(),
    'restantes' => 0,
    'dias_restantes' => 0,
  ]);
  exit;
}
