<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json; charset=utf-8');

$usuarioEmail = $_SESSION['usuario_email'] ?? null; // <- ajuste aqui
if (!$usuarioEmail) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Usuário não autenticado.']);
    exit;
}

$acao = $_POST['acao'] ?? '';

try {
    if ($acao === 'listar') {

        $plataformas = load_plataformas($pdo, $usuarioEmail);
        echo json_encode([
            'ok'          => true,
            'plataformas' => $plataformas,
        ]);
        exit;
    }

    if ($acao === 'salvar') {
        $nome        = trim($_POST['nome'] ?? '');
        $taxaStr     = str_replace(',', '.', $_POST['taxa'] ?? '0');
        $custoStr    = str_replace(',', '.', $_POST['custo_fixo'] ?? '0');
        $slug        = trim($_POST['slug'] ?? '');
        $originalSlug= trim($_POST['original_slug'] ?? '');

        if ($nome === '') {
            throw new Exception('Informe o nome da plataforma.');
        }
        if (!is_numeric($taxaStr)) {
            throw new Exception('Taxa inválida.');
        }

        $taxa  = (float) $taxaStr;
        $custo = (float) $custoStr;

        if ($slug === '') {
            $slug = gerar_slug_plataforma($nome);
        }

        salvar_plataforma(
            $pdo,
            $usuarioEmail,
            $slug,
            $nome,
            $taxa,
            $custo,
            $originalSlug ?: null
        );

        echo json_encode([
            'ok'   => true,
            'slug' => $slug,
            'plataforma' => [
                'nome'        => $nome,
                'taxaPercent' => $taxa,
                'custoFixo'   => $custo,
            ],
        ]);
        exit;
    }

    if ($acao === 'excluir') {
        $slug = trim($_POST['slug'] ?? '');
        if ($slug === '') {
            throw new Exception('Slug não informado.');
        }

        excluir_plataforma($pdo, $usuarioEmail, $slug);

        echo json_encode(['ok' => true]);
        exit;
    }

    throw new Exception('Ação inválida.');

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'ok'  => false,
        'msg' => $e->getMessage(),
    ]);
    exit;
}
