<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json; charset=utf-8');

// ajuste esse índice conforme o que você usa no login
$usuarioEmail = $_SESSION['usuario_email'] ?? null;

if (!$usuarioEmail) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Usuário não autenticado.']);
    exit;
}

try {
    // Pega exatamente os nomes que o JS envia
    $cmv                 = str_replace(',', '.', $_POST['cmv'] ?? '0');
    $despesas_fixas      = str_replace(',', '.', $_POST['despesas_fixas'] ?? '0');
    $taxa_mentoria       = str_replace(',', '.', $_POST['taxa_mentoria'] ?? '0');
    $custo_fixo_plat     = str_replace(',', '.', $_POST['custo_fixo_plataforma'] ?? '0');
    $taxa_plataforma     = str_replace(',', '.', $_POST['taxa_plataforma'] ?? '0');
    $fat_12m             = str_replace(',', '.', $_POST['fat_12m'] ?? '0');
    $lucro_desejado      = str_replace(',', '.', $_POST['lucro_desejado'] ?? '0');

    $dados = [
        'cmv'                   => $cmv,
        'despesas_fixas'        => $despesas_fixas,
        'taxa_mentoria'         => $taxa_mentoria,
        'custo_fixo_plataforma' => $custo_fixo_plat,
        'taxa_plataforma'       => $taxa_plataforma,
        'fat_12m'               => $fat_12m,
        'lucro_desejado'        => $lucro_desejado,
    ];

    salvar_user_defaults($pdo, $usuarioEmail, $dados);

    echo json_encode(['ok' => true]);
    exit;

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => $e->getMessage()]);
    exit;
}
