<?php
// trial.php
require __DIR__ . '/db.php';

// Carrega limites de trial a partir do banco (tabela app_settings)
require_once __DIR__ . '/functions.php';
$TRIAL_MAX_SIMULACOES = (int) get_app_setting($pdo, 'trial_max_simulacoes', '3');
$TRIAL_MAX_DIAS       = (int) get_app_setting($pdo, 'trial_max_dias', '7');
if ($TRIAL_MAX_SIMULACOES <= 0) {
  $TRIAL_MAX_SIMULACOES = 3;
}
if ($TRIAL_MAX_DIAS <= 0) {
  $TRIAL_MAX_DIAS = 7;
}



if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

$pageTitle = 'Trial - Formação de Preço';
$erro = '';
$ok   = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nome  = isset($_POST['nome']) ? trim($_POST['nome']) : '';
  $email = isset($_POST['email']) ? trim($_POST['email']) : '';

  if ($nome === '' || $email === '') {
    $erro = 'Informe nome e e-mail.';
  } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $erro = 'E-mail inválido.';
  } else {
    try {
      $stmt = $pdo->prepare('SELECT *, TIMESTAMPDIFF(DAY, created_at, NOW()) AS dias_desde FROM usuarios_trial WHERE email = :email LIMIT 1');
      $stmt->execute([':email' => $email]);
      $row = $stmt->fetch();

      if (!$row) {
        $stmtIns = $pdo->prepare('INSERT INTO usuarios_trial (nome, email, sim_count, created_at) VALUES (:nome, :email, 0, NOW())');
        $stmtIns->execute([':nome' => $nome, ':email' => $email]);

        $row = [
          'nome'        => $nome,
          'email'       => $email,
          'sim_count'   => 0,
          'dias_desde'  => 0,
        ];
      }

      $simCount   = (int)$row['sim_count'];
      $diasDesde  = isset($row['dias_desde']) ? (int)$row['dias_desde'] : 0;

      if ($simCount >= (int)$TRIAL_MAX_SIMULACOES || $diasDesde >= (int)$TRIAL_MAX_DIAS) {
        $erro = 'Seu período de teste já foi utilizado ou expirou (limite de ' . (int)$TRIAL_MAX_SIMULACOES . ' simulações ou ' . (int)$TRIAL_MAX_DIAS . ' dias).';
      } else {
        $_SESSION['usuario_autorizado'] = true;
        $_SESSION['usuario_email']      = $row['email'];
        $_SESSION['usuario_nome']       = $row['nome'];
        $_SESSION['usuario_trial']      = true;

        $restantes = max(0, (int)$TRIAL_MAX_SIMULACOES - $simCount);
        $_SESSION['trial_restantes']    = $restantes;

        header('Location: index.php');
        exit;
      }
    } catch (Exception $e) {
      $erro = 'Erro ao registrar trial: ' . $e->getMessage();
    }
  }
}

include __DIR__ . '/header.php';
?>

<div class="grid">
  <div class="card" style="max-width:520px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Versão Trial</div>
      <span class="badge">3 SIMULAÇÕES · 7 DIAS</span>
    </div>

    <div class="field">
      <label>Como funciona?</label>
      <div class="hint">
        - Você pode testar o APP gratuitamente com até <?php echo (int)$TRIAL_MAX_SIMULACOES; ?> simulações de cálculo.<br>
        - O período de uso é de até <?php echo (int)$TRIAL_MAX_DIAS; ?> dias a partir do primeiro acesso.<br>
        - Basta informar seu nome e e-mail abaixo.<br>
        - Depois de atingir o limite, será necessário adquirir a licença completa.
      </div>
    </div>

    <form method="post" action="trial.php" style="margin:0;padding:0;">
      <div class="field">
        <label>Nome completo</label>
        <input
          type="text"
          name="nome"
          placeholder="Ex: João da Silva"
          value="<?php echo isset($nome) ? htmlspecialchars($nome) : ''; ?>"
        >
      </div>

      <div class="field">
        <label>E-mail</label>
        <input
          type="email"
          name="email"
          placeholder="voce@empresa.com"
          value="<?php echo isset($email) ? htmlspecialchars($email) : ''; ?>"
        >
      </div>

      <?php if (!empty($erro)): ?>
        <div class="metric metric-danger" style="margin-top:8px;">
          <div class="metric-label">
            <span>Não foi possível ativar o trial</span>
          </div>
          <div class="metric-value metric-small" style="font-size:0.8rem;">
            <?php echo nl2br(htmlspecialchars($erro)); ?>
          </div>
        </div>
      <?php endif; ?>

      <?php if (!empty($ok)): ?>
        <div class="metric metric-highlight" style="margin-top:8px;">
          <div class="metric-label">
            <span>Trial ativado</span>
          </div>
          <div class="metric-value metric-small" style="font-size:0.8rem;">
            <?php echo nl2br(htmlspecialchars($ok)); ?>
          </div>
        </div>
      <?php endif; ?>

      <hr class="divider">

      <div class="field">
        <button
          type="submit"
          class="btn"
          style="width:100%;justify-content:center;font-size:0.9rem;"
        >
          <span class="dot"></span> Entrar no APP em modo Trial
        </button>
      </div>
    </form>

    <div class="field" style="margin-top:10px;">
      <div class="hint">
        Já comprou a licença completa?<br>
        <a href="login.php" style="color:#38bdf8;text-decoration:none;">
          Clique aqui para fazer login
        </a>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
