const router = require('express').Router();
const db = require('../config/db');

async function pickAvailableAgent() {
  const result = await db.query(
    `SELECT u.id
     FROM users u
     LEFT JOIN conversations c
       ON c.assigned_user_id = u.id
      AND c.status = 'open'
     WHERE u.role IN ('agent', 'admin')
     GROUP BY u.id
     ORDER BY COUNT(c.id) ASC
     LIMIT 1`
  );

  if (!result.rowCount) return null;
  return result.rows[0].id;
}

router.post('/wppconnect', async (req, res) => {
  const io = req.app.get('io');
  const { session, event, payload } = req.body;

  try {
    // Ajuste este parser conforme o formato exato do webhook do seu WPPConnect
    const msg = payload || {};
    if (!msg.from) {
      return res.sendStatus(200);
    }

    const from = msg.from; // ex: '5511999999999@c.us'
    const body = msg.body || '';
    const waMessageId = msg.id?._serialized || msg.id || null;
    const phoneNumber = from.replace(/@.*/, '');
    const contactName = msg.sender?.pushname || msg.sender?.name || null;

    const contactResult = await db.query(
      `INSERT INTO contacts (wa_id, phone_number, name)
       VALUES ($1, $2, $3)
       ON CONFLICT (wa_id)
       DO UPDATE SET phone_number = EXCLUDED.phone_number,
                     name = COALESCE(EXCLUDED.name, contacts.name)
       RETURNING *`,
      [from, phoneNumber, contactName]
    );
    const contact = contactResult.rows[0];

    let sessionId;
    const sRes = await db.query(
      'SELECT id FROM wa_sessions WHERE name = $1 LIMIT 1',
      [session || 'default']
    );
    if (sRes.rowCount) {
      sessionId = sRes.rows[0].id;
    } else {
      const insS = await db.query(
        'INSERT INTO wa_sessions (name, status) VALUES ($1, $2) RETURNING id',
        [session || 'default', 'connected']
      );
      sessionId = insS.rows[0].id;
    }

    let convRes = await db.query(
      `SELECT * FROM conversations
       WHERE contact_id = $1 AND wa_session_id = $2 AND status = 'open'
       LIMIT 1`,
      [contact.id, sessionId]
    );

    let conversation;
    if (!convRes.rowCount) {
      const agentId = await pickAvailableAgent();
      const insConv = await db.query(
        `INSERT INTO conversations (contact_id, wa_session_id, status, assigned_user_id, last_message_at)
         VALUES ($1, $2, 'open', $3, NOW())
         RETURNING *`,
        [contact.id, sessionId, agentId]
      );
      conversation = insConv.rows[0];
    } else {
      conversation = convRes.rows[0];
      await db.query(
        'UPDATE conversations SET last_message_at = NOW() WHERE id = $1',
        [conversation.id]
      );
    }

    const msgRes = await db.query(
      `INSERT INTO messages (conversation_id, direction, wa_message_id, body)
       VALUES ($1, 'in', $2, $3)
       RETURNING *`,
      [conversation.id, waMessageId, body]
    );
    const message = msgRes.rows[0];

    if (conversation.assigned_user_id) {
      io.to(`user:${conversation.assigned_user_id}`).emit('new_message', {
        conversation,
        message,
        contact
      });
    } else {
      io.emit('new_conversation', { conversation, message, contact });
    }

    res.sendStatus(200);
  } catch (err) {
    console.error('Erro no webhook WPPConnect:', err);
    res.sendStatus(500);
  }
});

module.exports = router;
