-- usuários (atendentes/admin)
CREATE TABLE IF NOT EXISTS users (
  id SERIAL PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  email VARCHAR(120) UNIQUE NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  role VARCHAR(20) DEFAULT 'agent',
  created_at TIMESTAMP DEFAULT NOW()
);

-- sessões/números do WhatsApp
CREATE TABLE IF NOT EXISTS wa_sessions (
  id SERIAL PRIMARY KEY,
  name VARCHAR(50) UNIQUE NOT NULL,
  phone_number VARCHAR(20),
  status VARCHAR(20),
  created_at TIMESTAMP DEFAULT NOW()
);

-- contatos
CREATE TABLE IF NOT EXISTS contacts (
  id SERIAL PRIMARY KEY,
  wa_id VARCHAR(50) UNIQUE NOT NULL,
  phone_number VARCHAR(20),
  name VARCHAR(120),
  created_at TIMESTAMP DEFAULT NOW()
);

-- conversas
CREATE TABLE IF NOT EXISTS conversations (
  id SERIAL PRIMARY KEY,
  contact_id INT NOT NULL REFERENCES contacts(id),
  wa_session_id INT NOT NULL REFERENCES wa_sessions(id),
  status VARCHAR(20) DEFAULT 'open',
  assigned_user_id INT REFERENCES users(id),
  last_message_at TIMESTAMP,
  created_at TIMESTAMP DEFAULT NOW()
);

-- mensagens
CREATE TABLE IF NOT EXISTS messages (
  id SERIAL PRIMARY KEY,
  conversation_id INT NOT NULL REFERENCES conversations(id),
  direction VARCHAR(10) NOT NULL,
  wa_message_id VARCHAR(100),
  body TEXT,
  type VARCHAR(30) DEFAULT 'chat',
  created_at TIMESTAMP DEFAULT NOW(),
  delivered_at TIMESTAMP,
  read_at TIMESTAMP
);

INSERT INTO users (name, email, password_hash, role)
VALUES (
  'Admin',
  'admin@teste.com',
  '$2a$10$Wv2h4z1V3oQjeVgY4C/7Ieh9aVQPGyHhVgU7r7B2W9QpI4rI8Qk5e',
  'admin'
)
ON CONFLICT (email) DO NOTHING;
